/* 
retire(X,L1,L2) predicat ou X est un element de la liste L1 et est
enleve a L1 pour donner la nouvelle liste L2
*/ 

retire(X,[X|R],R).
retire(X,[Y|R],[Y|L]):-retire(X,R,L).

/*
appartient(X,L) predicat ou X est un element de la liste L
*/

appartient(X,[X|_]).
appartient(X,[_|R]):-appartient(X,R).

/*
repartition(Liste) predicat ou Liste est la liste des solutions ou
une solution est elle meme une liste de 19 entiers valeurs de chaque
noeud de l hexagone (voir ordre dans le dossier) pour satisfaire la
condition les sommes des entiers situes sur toute ligne doivent etre 
toutes identiques
*/

repartition(Liste):-
	
	L0 = [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19],

		retire(A,L0,L1),		
		retire(B,L1,L2),		
		C is 38-A-B,
		C<20,
		A<C,
		retire(C,L2,L3),	

		retire(G,L3,L4),		
		L is 38-C-G,
		L<20,
		A<L,
		retire(L,L4,L5),

		retire(P,L5,L6),
		S is 38-L-P,
		S<20,
		A<S,
		retire(S,L6,L7),
	
		retire(R,L7,L8),		
		Q is 38-S-R,
		Q<20,
		A<Q,
		retire(Q,L8,L9),

		retire(M,L9,L10),		
		H is 38-Q-M,
		H<20,
		A<H,
		C>H,
		retire(H,L10,L11),
		
		D is 38-H-A,
		D<20,
		retire(D,L11,L12),
				
		retire(E,L12,L13),			
		F is 38-D-E-G,
		F<20,
		retire(F,L13,L14),
		
		K is 38-B-F-P,
		K<20,
		retire(K,L14,L15),
			
		O is 38-G-K-R,
		O<20,
		retire(O,L15,L16),

		N is 38-P-O-M,
		N<20,
		retire(N,L16,L17),
		
		I is 38-R-N-D,
		I<20,
		retire(I,L17,L18),

		S12 is M+I+E+B,
		S12 = S38,

		J is 38-H-I-K-L,
		J<20,
	        appartient(J,L18),

		S14 is A+E+J+O+S,
		S14 = 38,
		S15 is C+F+J+N+Q,
		S15 = S14,
	
	/*premiere solution*/	
			Lis1  = [A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S],
	/*rotation 60 a droite*/	
			Lis2  = [H,D,A,M,I,E,B,Q,N,J,F,C,R,O,K,G,S,P,L],
	/*rotation 60 a gauche*/	
			Lis3  = [C,G,L,B,F,K,P,A,E,J,O,S,D,I,N,R,H,M,Q],
	/*rotation 120 a droite*/	
			Lis4  = [Q,M,H,R,N,I,D,S,O,J,E,A,P,K,F,B,L,G,C],
	/*rotation 120 a gauche*/	
			Lis5  = [L,P,S,G,K,O,R,C,F,J,N,Q,B,E,I,M,A,D,H],
	/*rotation 180*/	
			Lis6  = [S,R,Q,P,O,N,M,L,K,J,I,H,G,F,E,D,C,B,A],
	/*symetrie d axe HIJKL*/	
			Lis7  = [Q,R,S,M,N,O,P,H,I,J,K,L,D,E,F,G,A,B,C],
	/*symetrie d axe QNJFC*/	
			Lis8  = [L,G,C,P,K,F,B,S,O,J,E,A,R,N,I,D,Q,M,H],
	/*symetrie d axe AEJOS*/	
			Lis9  = [A,D,H,B,E,I,M,C,F,J,N,Q,G,K,O,R,L,P,S],
	/*symetrie d axe BJR*/
			Lis10 = [C,B,A,G,F,E,D,L,K,J,I,H,P,O,N,M,S,R,Q],
	/*symetrie d axe MJG*/
			Lis11 = [S,P,L,R,O,K,G,Q,N,J,F,C,M,I,E,B,H,D,A],
	/*symetrie d axe DJP*/
			Lis12 = [H,M,Q,D,I,N,R,A,E,J,O,S,B,F,K,P,C,G,L],

	Liste = [Lis1,Lis2,Lis3,Lis4,Lis5,Lis6,Lis7,Lis8,Lis9,Lis10,Lis11,Lis12].
