/* 
retire(X,L1,L2) predicat ou X est un element de la liste L1 et est
enleve a L1 pour donner la nouvelle liste L2
*/ 

retire(X,[X|R],R).
retire(X,[Y|R],[Y|L]):-retire(X,R,L).

/*
appartient(X,L) predicat ou X est un element de la liste L
*/

appartient(X,[X|_]).
appartient(X,[_|R]):-appartient(X,R).


/*
repartition(Liste) predicat ou Liste est une solution au probleme de
la forme [A,B,C,D,E,F,G,H,I,J,K,,L,M,N,O,P,Q,R,S] ou les lettres 
A a S sont les valeurs de chaque noeud de l hexagone 
(voir ordre dans le dossier) pour satisfaire la condition les sommes 
des entiers situes sur toute ligne doivent etre toutes identiques
*/

repartition(Liste):-
	
	L0 = [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19],

			retire(A,L0,L1),		
			retire(B,L1,L2),		
			retire(C,L2,L3),
			S1 is A+B+C,
			S1 = 38,

			retire(G,L3,L4),		
			retire(L,L4,L5),
			S2 is C+G+L, 
			S2 = S1,
		
			retire(P,L5,L6),
			retire(S,L6,L7),
			S3 is L+P+S,
			S3 = S2,	

			retire(R,L7,L8),		
			retire(Q,L8,L9),
			S4 is S+R+Q,
			S4 = S3,

			retire(M,L9,L10),		
			retire(H,L10,L11),
			S5 is Q+M+H,
			S5 = S4,
		
			retire(D,L11,L12),
			S6 is H+D+A,
			S6 = S5,
		
			retire(E,L12,L13),			
			retire(F,L13,L14),
			S7 is D+E+F+G,
			S7 = S6,
		
			retire(K,L14,L15),
			S8 is B+F+K+P,
			S8 = S7,
			
			retire(O,L15,L16),
			S9 is G+K+O+R,
			S9 = S8,
		
			retire(N,L16,L17),
			S10 is P+O+N+M,
			S10 = S9,
		
			retire(I,L17,L18),
			S11 is R+N+I+D,
			S11 = S10,
			S12 is M+I+E+B,
			S12 = S11,

			appartient(J,L18),
			S13 is H+I+J+K+L,
			S13 = S12,
			S14 is A+E+J+O+S,
			S14 = S13,
			S15 is C+F+J+N+Q,
			S15 = S14,
	
	Liste = [A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S].